unit ndsList;

interface

uses
  {$IFDef Win32}
  Windows, 
  {$ENDIF}
  Messages, 
  SysUtils, 
  Classes, 
  Graphics, 
  Controls, 
  Forms, 
  Dialogs,
  StdCtrls, 
  ExtCtrls, 
  NWServer, 
  Nwnds, 
  Nwlib, 
  Nwtools ;

type
  TwinNdsList = class(TForm)
    leftPanel: TPanel;
    rightPanel: TPanel;
    mainList: TListBox;
    contextPanel: TPanel;
    contextName: TEdit;
    Label1: TLabel;
    contextBtn: TButton;
    givenName: TEdit;
    surname: TEdit;
    commonName: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    deleteBtn: TButton;
    infoBtn: TButton;
    quitBtn: TButton;
    Label5: TLabel;
    className: TEdit;
    passBtn: TButton;
    Label7: TLabel;
    lastLogin: TEdit;
    Label8: TLabel;
    passwordExpiresDate: TEdit;
    Label6: TLabel;
    passwordMinLength: TEdit;
    passwordUnique: TCheckBox;
    multiList: TMemo;
    multiRadio: TRadioGroup;
    procedure contextBtnClick(Sender: TObject);
    procedure mainListDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure deleteBtnClick(Sender: TObject);
    procedure infoBtnClick(Sender: TObject);
    procedure passBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winNdsList: TwinNdsList;

implementation

{$R *.DFM}

procedure TwinNdsList.FormCreate(Sender: TObject);
  begin
    contextName.text := ndsGetContextName ;
    {don't show cn=, ou= o= notation in nds names}
    ndsSetContextFlags(DCV_TYPELESS_NAMES) ;
  end;

procedure TwinNdsList.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
    ndsSetContext('[root]');
  end;

procedure TwinNdsList.contextBtnClick(Sender: TObject);
  begin
    if (length(contextName.text) < 1) then
      contextName.text := '[Root]' ;
    if ndsSetContext(contextName.text) then
      with mainList do begin
        items.beginUpdate ;
        items.clear ;
        items.addStrings(nwnds.ndsList('','')) ; {oops - formname is same fn name}
        items.endUpdate ;
      end             
    else
      begin
        alertBox(contextName.text + ';Error Setting Context') ;
        contextName.text := ndsGetContextName ;
      end;  
  end;

procedure TwinNdsList.mainListDblClick(Sender: TObject);
  var
    context,
    ctemp : string ;
  begin
    with mainList do begin
      if (items.count < 1) then
        exit ;
      if (itemIndex < 0) then
        itemIndex := 0 ;
      ctemp := items[itemIndex] ;  
      context := ndsGetContextName ;
      if (upperCase(context) = '[ROOT]') then
        context := ''
      else
        context := '.' + context ;  
      if (not ndsSetContext(ctemp + context)) then {ie 'jim' + '.development.devont'}
        begin
          alertBox(ctemp + ';Object Contains No Subordinates') ;
          exit ;
        end;
      items.beginUpdate ;
      items.clear ;
      items.addStrings(nwnds.ndsList('','')) ;
      items.endUpdate ;
      contextName.text := ctemp + context ;
    end;
  end;



procedure TwinNdsList.deleteBtnClick(Sender: TObject);
  var
    ctemp : string ;
  begin
    with mainList do begin
      if (items.count < 1) then
        exit ;
      if (itemIndex < 0) then
        itemIndex := 0 ;
      ctemp := items[itemIndex] ;
      if noYesBox(ctemp + ';;Permanently Removing Object;;Are You Sure?') then
        begin
          if ndsRemoveObject(contextName.text,ctemp) then
            okBox(ctemp + ';Object Removed From Tree Successfully') 
          else
            alertBox(ctemp + ';;Object Not Removed!;Ensure Object Contains No Subordinates') ;
        end;
    end;  
  end;

procedure TwinNdsList.infoBtnClick(Sender: TObject);
  var
    boolValue  : boolean   ;
    nloop      : integer   ;
    intValue   : longint   ;
    dateValue  : TDateTime ;
    tempList   : TList     ;
    objName,
    strValue   : string    ;
  begin
    {ndsGetMultiAttr uses a TList to hold object attributes.  The
    list is filled with various data types, depending on the type
    of object attribute being fetched from nds.  
    
    Init the list used to retrive multi-value object attributes}
    tempList := TList.create ;
    
    try
      with mainList do 
        if (items.count < 1) or (itemIndex < 0) then
          exit 
        else  
          objName := items[maxLong(0,itemIndex)] ;
      commonName.text          := '[Unknown]' ;
      className.text           := '[Unknown]' ;
      surname.text             := '[Unknown]' ;
      givenName.text           := '[Unknown]' ;
      lastLogin.text           := '[Unknown]' ;
      lastLogin.text           := '[Unknown]' ;
      passwordExpiresDate.text := '[Unknown]' ;
      passwordMinLength.text   := '[Unknown]' ;
      {string example}
      if ndsGetStringAttr('',objName,dsaCommonName,strValue) then
        commonName.text := strValue;
      if ndsGetStringAttr('',objName,dsaClassName,strValue) then
        className.text := strValue ;
      if ndsGetStringAttr('',objName,dsaSurname,strValue) then
        surname.text := strValue ;
      if ndsGetStringAttr('',objName,dsaGivenName,strValue) then
        givenName.text := strValue ;
      {date/time example - Remember Novell returns UTC Date/Times}  
      if ndsGetDateTimeAttr('',objName,dsaPasswordExpirationTime,dateValue) then
        passwordExpiresDate.text := formatDateTime('mm/dd/yyyy hh:mm a/p',dateValue) + 
                          '   (UTC Time)' ;
      
      if ndsGetDateTimeAttr('',objName,dsaLastLoginTime,dateValue) then
        lastLogin.text := formatDateTime('mm/dd/yyyy hh:mm a/p',dateValue) + 
                          '   (UTC Time)' ; 
      {integer example}                    
      if ndsGetIntegerAttr('',objName,dsaPasswordMinimumLength,intValue) then
        passwordMinLength.text := intToStr(intValue) ;
      {boolean example}  
      if ndsGetBooleanAttr('',objName,dsaPasswordUniqueRequired,boolValue) then
        passwordUnique.checked := boolValue ;
        
      {********** Reading Multi-Valued NDS Attributes ************ 

      This code fills up our TList object, and
       then shows the values in the listbox object
       
      see SDK's nwdsdefs.inc for example data types.  we include a 
       couple of the more popular types below

      ************ } 
       
      with multiList.lines do begin
        beginUpdate ;
        clear ;
        case multiRadio.itemIndex of
          {email addresses}
          0: if ndsGetMultiAttr('',objName,dsaEMailAddress,tempList) then
               for nloop := 0 to (tempList.count -1) do 
                 add(TNWDSEMailInfo(tempList[nloop]^).eMailAddress) ;
          {phone numbers}       
          1: if ndsGetMultiAttr('',objName,dsaTelephoneNumber,tempList) then
               for nloop := 0 to (tempList.count -1) do 
                 add(strPas(tempList[nloop])) ;
          {fax numbers}       
          2: if ndsGetMultiAttr('',objName,dsaFacsimileTelephoneNumber,tempList) then
               for nloop := 0 to (tempList.count -1) do 
                 add(TNWDSPhoneInfo(tempList[nloop]^).phoneNumber) ;
          {members - adds a classType test just for fun}       
          3: if (ndsGetObjType('',objName) <> dsoGroup) then
               add('[Not a Group]')
             else if ndsGetMultiAttr('',objName,dsaMember,tempList) then 
               for nloop := 0 to (tempList.count -1) do 
                 add(strPas(tempList[nloop])) ; 
        end;   
        if (count < 1) then
          add('[None]') ;
        endUpdate ;         
      end;
      ndsGetObjType('',objName) ;
    finally
      {clear allocations created by ndsGetMultiAttr() call}  
      for nloop := 0 to (tempList.count -1) do
        freeMem(tempList[nloop],sizeOf(tempList[nloop]^)) ;
        
      tempList.free ;
    end;  
  end;

procedure TwinNdsList.passBtnClick(Sender: TObject);
  var
    objName,
    oldPass,
    newPass  : string;
  begin
    oldPass := '' ;
    newPass := '' ;
    with mainList do begin
      if (items.count < 0) then
        exit ;
      if (itemIndex < 0) then
        itemIndex := 0 ;
      objName := items[itemIndex] ;
    end;  
    if inputQuery('Change Password','Type OLD Password:',oldPass) and
       inputQuery('Change Password','Type NEW Password:',newPass) then
      begin
        if ndsChangePassword('',objName,newPass,oldPass) then
          okBox('Object Password Changed Successfully')
        else
          alertBox('Object Password Not Changed!') ;  
      end;  
  end;

end.
 